# Al Ghazal WhatsApp Bot

A comprehensive WhatsApp chatbot for Al Ghazal car rental and limousine services, facilitating customer interactions, bookings, and support inquiries in both Arabic and English.

## 🔄 Recent Updates (May 2024)

### Code Refactoring & Improvements
- **Simplified Session Management**: Removed redundant `$idChat` parameter and standardized on using `$to` (recipient phone number) as the primary session identifier across all handlers.
- **Improved Code Organization**: Enhanced code structure for better maintainability and readability with dedicated handler classes for each feature.
- **Consistent Parameter Naming**: Standardized parameter names and method signatures across all handler classes.
- **State Management**: Improved state transitions between different menu levels and conversation flows.
- **Message Formatting**: Added zero-width spaces before asterisks in menu options for better WhatsApp message rendering.

### Bug Fixes
- Fixed session management issues that could occur during concurrent user interactions.
- Resolved potential state management edge cases in multi-step conversation flows.
- Fixed infinite loop issues in main menu handling by correcting the method call in `MainMenuHandler`.
- Corrected session state management in various handlers to ensure proper navigation.
- Fixed typo in CustomerServiceHandler where state was being set to 'main_me' instead of 'main_menu'.

## ✨ Features

- **Car Rental Booking** - Browse and book available vehicles
- **Limousine Service** - Premium limousine booking service
- **Accident Reporting** - Report and manage accident cases
- **Contract Extensions** - Extend existing rental contracts
- **Branch Information** - Find nearby branches and their details
- **Special Offers** - View and redeem current promotions
- **Multi-language Support** - Full support for Arabic (AR) and English (EN)
- **Session Management** - Maintains conversation state
- **Customer Support** - Direct access to support representatives
- **Rating System** - Collect customer feedback

## 🚀 Requirements

- PHP 7.4 or higher
- Composer for dependency management
- UltraMsg WhatsApp Business API access
- Web server (Apache/Nginx recommended)
- Write permissions for session and log directories
- PHP extensions: json, pdo, pdo_mysql (if using database sessions)

## 🛠️ Installation

1. **Clone the repository**
   ```bash
   git clone [repository-url]
   cd webhook
   ```

2. **Install dependencies**
   ```bash
   composer install
   ```

3. **Configure the application**
   - Update API credentials in `src/Config/config.php`
   - Configure webhook URL in your WhatsApp Business API settings
   - Ensure proper file permissions for logs and sessions

## 📁 Project Structure

```
webhook/
├── data/                   # Session data storage (JSON files)
├── logs/                   # Application logs
├── src/                    # Source code
│   ├── Config/            # Configuration files
│   │   └── config.php     # Main configuration
│   ├── Core/              # Core application classes
│   │   ├── MessageProcessor.php  # Routes messages to appropriate handlers
│   │   └── SessionManager.php    # Manages user session state
│   ├── Handlers/          # Message handlers (one per feature)
│   │   ├── BaseHandler.php       # Base handler with common functionality
│   │   ├── MainMenuHandler.php   # Main menu navigation
│   │   ├── CarRentalHandler.php  # Car rental services
│   │   ├── LimoServiceHandler.php # Limousine booking
│   │   ├── AccidentReportHandler.php # Accident reporting flow
│   │   ├── SpecialOffersHandler.php # Promotions and offers
│   │   ├── BranchInquiryHandler.php # Branch locations and info
│   │   ├── CustomerServiceHandler.php # Customer support
│   │   ├── RatingHandler.php     # Customer feedback collection
│   │   └── WelcomeHandler.php    # Welcome and language selection
│   ├── Services/          # Service classes
│   │   ├── maqamApiService.php  # Integration with Al Ghazal API
│   │   └── WhatsAppService.php   # WhatsApp message handling
│   └── Utils/             # Utility classes
│       ├── Helpers.php           # Helper functions
│       ├── Logger.php            # Logging utilities
│       ├── MenuHelper.php        # Menu generation
│       └── MessageFormatter.php  # Message formatting
├── vendor/                # Composer dependencies
├── Webhook.php           # Main webhook handler
├── composer.json         # PHP dependencies
├── index.php             # Entry point
├── webhook.php          # Webhook endpoint
├── rating.php           # Rating system handler
├── sendsms.php          # SMS sending functionality
└── sessionexpire.php    # Session expiration handler
```

## 🔄 Message Flow

### 1. Initialization
   - User initiates chat
   - System detects new user or existing session
   - Welcome message with language selection (AR/EN)
   - Main menu displayed after language selection

### 2. Main Menu Navigation
   - 1️⃣ Customer Service
     - Chat with representative
     - Call customer service
     - Submit a complaint
   - 2️⃣ Car Rental
     - Browse available vehicles
     - Check pricing
     - Make a reservation
   - 3️⃣ Report an Accident
     - Initiate accident report
     - Upload images
     - Submit details
   - 4️⃣ Extend Rental
     - View current rental
     - Request extension
     - Confirm new end date
   - 5️⃣ Book a Limousine
     - Select limo type
     - Choose date/time
     - Confirm booking
   - 6️⃣ Special Offers
     - View current promotions
     - Redeem offers
   - 7️⃣ Branch Inquiry
     - Find nearby branches
     - View contact information
     - Get directions

### 3. Session Management
   - Each user interaction maintains session state
   - Session data stored in JSON files
   - Timeout after period of inactivity
   - State automatically resets after completion

### 4. Technical Implementation
   - **Handler Pattern**: Each feature has a dedicated handler class
   - **Dependency Injection**: Services injected via constructors
   - **State Management**: SessionManager handles conversation state
   - **Error Handling**: Graceful degradation on errors
   - **Logging**: Comprehensive logging for debugging
   - **Multi-language**: Full support for AR/EN with easy extension

## 🛠 Development

### Code Style
- Follows PSR-4 autoloading standards
- Adheres to PSR-12 coding style
- Uses type hints and return type declarations
- Includes PHPDoc blocks for documentation

### Adding New Handlers
1. Create a new handler class in `src/Handlers/`
2. Extend `BaseHandler`
3. Implement required methods
4. Register the handler in `MessageProcessor`

### Configuration
Main configuration is managed in `src/Config/config.php`:
- WhatsApp API settings
- Al Ghazal API endpoints
- Logging configuration

## 🚀 Deployment

1. **Server Setup**
   - Configure web server to point to `public/`
   - Set up SSL/TLS for secure connections
   - Configure proper file permissions

2. **Dependencies**
   ```bash
   composer install --no-dev --optimize-autoloader
   ```

3. **Logs & Sessions**
   - Ensure `logs/` and `data/` directories are writable
   - Set up log rotation if needed

## 🔒 Security Considerations

- All user inputs are validated and sanitized
- Sensitive data is not logged
- Uses HTTPS for all API communications
- Regular dependency updates recommended
- Implement rate limiting at the web server level

## 🐛 Troubleshooting

1. **Check Logs**
   - Application logs in `logs/` directory
   - Web server error logs

2. **Common Issues**
   - Verify WhatsApp API credentials in config
   - Check session directory permissions
   - Ensure all required PHP extensions are installed
   - Validate webhook URL in WhatsApp Business settings

## 📝 License

Proprietary - © Al Ghazal. All rights reserved.

## 📞 Support

For technical support or assistance, please contact the development team.
