<?php
/**
 * Comprehensive test script for the Al Ghazal WhatsApp chatbot
 * 
 * This script provides a more interactive way to test the chatbot functionality
 */

// Include the autoloader
require_once __DIR__ . '/vendor/autoload.php';

// Import required classes
use AlGhazal\Core\MessageProcessor;
use AlGhazal\Core\SessionManager;

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Create data directory if it doesn't exist
$dataDir = __DIR__ . '/data';
if (!is_dir($dataDir)) {
    mkdir($dataDir, 0755, true);
}

// Clear the terminal
system('clear');

// Initialize the session manager to reset sessions if needed
$sessionManager = new SessionManager();

// Function to simulate a message and show the response
function simulateMessage($from, $to, $body) {
    echo "User: $body\n";
    
    // Create a message processor and process the message
    $processor = new MessageProcessor();
    $processor->processMessage($from, $to, $body, 'test_' . time());
    
    echo "------------------------------\n";
}

// Function to display menu options
function showMenu() {
    echo "\n=== Al Ghazal WhatsApp Chatbot Test Menu ===\n";
    echo "1. Test welcome flow\n";
    echo "2. Test customer service flow\n";
    echo "3. Test car rental flow\n";
    echo "4. Test branch inquiry flow\n";
    echo "5. Test special offers flow\n";
    echo "6. Test accident report flow\n";
    echo "7. Test custom message\n";
    echo "8. Reset session\n";
    echo "9. Exit\n";
    echo "Enter your choice: ";
}

// Define test phone numbers
$testFrom = '971501234567';
$testTo = '123456789';

// Main test loop
while (true) {
    showMenu();
    $choice = trim(fgets(STDIN));
    
    switch ($choice) {
        case '1':
            echo "\n=== Testing Welcome Flow ===\n";
            // Reset session to ensure we start fresh
            $sessionManager->clearSession($testFrom);
            simulateMessage($testFrom, $testTo, 'Hello');
            simulateMessage($testFrom, $testTo, '1'); // Select Arabic
            break;
            
        case '2':
            echo "\n=== Testing Customer Service Flow ===\n";
            // Ensure we're in the main menu
            simulateMessage($testFrom, $testTo, '0');
            simulateMessage($testFrom, $testTo, '1'); // Customer Service
            simulateMessage($testFrom, $testTo, '1'); // Chat with CS
            break;
            
        case '3':
            echo "\n=== Testing Car Rental Flow ===\n";
            // Ensure we're in the main menu
            simulateMessage($testFrom, $testTo, '0');
            simulateMessage($testFrom, $testTo, '2'); // Car Rental
            break;
            
        case '4':
            echo "\n=== Testing Branch Inquiry Flow ===\n";
            // Ensure we're in the main menu
            simulateMessage($testFrom, $testTo, '0');
            simulateMessage($testFrom, $testTo, '7'); // Branch Inquiry
            break;
            
        case '5':
            echo "\n=== Testing Special Offers Flow ===\n";
            // Ensure we're in the main menu
            simulateMessage($testFrom, $testTo, '0');
            simulateMessage($testFrom, $testTo, '6'); // Special Offers
            break;
            
        case '6':
            echo "\n=== Testing Accident Report Flow ===\n";
            // Ensure we're in the main menu
            simulateMessage($testFrom, $testTo, '0');
            simulateMessage($testFrom, $testTo, '3'); // Accident Report
            simulateMessage($testFrom, $testTo, 'Test accident report');
            break;
            
        case '7':
            echo "\n=== Testing Custom Message ===\n";
            echo "Enter your message: ";
            $message = trim(fgets(STDIN));
            simulateMessage($testFrom, $testTo, $message);
            break;
            
        case '8':
            echo "\n=== Resetting Session ===\n";
            $sessionManager->clearSession($testFrom);
            echo "Session reset successfully.\n";
            break;
            
        case '9':
            echo "\n=== Exiting Test Script ===\n";
            exit(0);
            
        default:
            echo "\nInvalid choice. Please try again.\n";
    }
}
