<?php
namespace AlGhazal\Handlers;

use AlGhazal\Services\WhatsAppService;
use AlGhazal\Utils\Helpers;
use AlGhazal\Utils\MenuHelper;

/**
 * Base handler class for conversation flows
 */
abstract class BaseHandler {
    protected WhatsAppService $whatsAppService;

    /**
     * Constructor
     */
    public function __construct() {
        $this->whatsAppService = new WhatsAppService();
    }
    
    /**
     * Handle the message based on the conversation flow
     * 
     * @param string $to Recipient phone number (used as chat ID)
     * @param string $body Message body
     * @param string $language Language (AR or EN)
     * @return bool Whether the message was handled
     */
    abstract public function handle($to, $body, $language);
    
    /**
     * Send a message to the user
     * 
     * @param string $to Recipient phone number
     * @param string $message Message text
     * @return array
     */
    protected function sendMessage($to, $message) {
        return $this->whatsAppService->sendMessage($to, $message);
    }
    
    /**
     * Send an image to the user
     * 
     * @param string $to Recipient phone number
     * @param string $image Image URL or path
     * @param string $caption Image caption
     * @return array
     */
    protected function sendImage($to, $image, $caption) {
        return $this->whatsAppService->sendImage($to, $image, $caption);
    }

    /**
     * Send main menu
     * 
     * @param string $to Recipient phone number
     * @param string $language Language (AR or EN)
     * @return void
     */
    protected function sendMainMenu($to, $language) {
        $message = MenuHelper::getMainMenuMessage($language);
        $this->sendMessage($to, $message);
    }
}
