<?php
namespace AlGhazal\Handlers;

use AlGhazal\Core\SessionManager;
use AlGhazal\Utils\MessageFormatter;

/**
 * Handler for car rental related flows
 */
class CarRentalHandler extends BaseHandler {
    private SessionManager $sessionManager;

    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
        $this->sessionManager = new SessionManager();
    }

    public function handle($to, $body, $language) {
        $state = $this->sessionManager->getState($to);
        if ($body == '1' && $state == 'main_menu') {
            $this->sendCarRentalMenu($to, $language);
            return true;
        }

        if ($body == '3' && $state == "main_menu"){
            $this->sendCarRentalReturnMenu($to , $language);
            return true;
        }

        switch ($state){
            case 'car_rental_menu':
                return $this->handlePickUpMenu($to, $body, $language);
        }
        return false;
    }

    private function sendCarRentalMenu($to, $language){
        if ($language == "AR"){
            $message = " تشرفنا بسيادتكم ونسعى دائما لتقديم افضل السيارات 😊" . "\n";
            $message .= "برجاء اختيار طريقة استلام السيارة 🙏" . "\n";
            $message .= "1- استلام من المكتب 🏢" . "\n";
            $message .= "2- استلام من المطار ✈" . "\n";
            $message .= "3- استلام في موقع خاص📍" . "\n";
            $message .= "‐--------------------------------" . "\n";
            $message .= "#- للرجوع للقائمة الرئيسية 📌" . "\n";

        }else{
            $message = "We are honored by your presence and always strive to provide the best cars 😊" . "\n";
            $message .= "Please choose the car delivery method 🙏" . "\n";
            $message .= "1- Pickup from the office 🏢" . "\n";
            $message .= "2- Airport pickup ✈" . "\n";
            $message .= "3- Delivery to a specific location 📍" . "\n";
            $message .= "‐--------------------------------" . "\n";
            $message .= "#- Return to main menu 📌" . "\n";
        }
        $this->sendMessage($to, $message);
        $this->sessionManager->setState($to, 'car_rental_menu');
        return true;
    }

    private function sendCarRentalReturnMenu($to, $language){
        if ($language == "AR"){
            $message = "شكرا لكم ونتمنى انها كانت رحلة امنة وممتعة 😊" . "\n";
            $message .= "برجاء اختيار طريقة تسليم السيارة 🙏" . "\n";
            $message .= "1- تسليم من المكتب 🏢" . "\n";
            $message .= "2- تسليم من المطار ✈" . "\n";
            $message .= "3- تسليم في موقع خاص📍" . "\n";

        }else{
            $message = "Thank you, we hope you had a safe and enjoyable trip 😊" . "\n";
            $message .= "Please choose the car return method 🙏" . "\n";
            $message .= "1- Return at the office 🏢" . "\n";
            $message .= "2- Return at the airport ✈" . "\n";
            $message .= "3- Return at a private location 📍" . "\n";
        }
        $this->sendMessage($to, $message);
        $this->sessionManager->setState($to, 'wait_for_support_response');
        return true;
    }

    private function handlePickUpMenu($to, $body, $language){
        if ($body == '#') {
            $this->sessionManager->setState($to, 'main_menu');
            $this->sendMainMenu($to, $language);
            return true;
        }

        switch ($body) {
            case '1':
                return $this->handlePickupOffice($to, $body, $language);
            case '2':
                return $this->handlePickUpAirport($to, $body, $language);
            case '3':
                return $this->handlePickUpPrivateLocation($to, $body, $language);
            default:
                return $this->handleInvalidOption($to, $language);
        }
    }

    private function handlePickupOffice($to, $body, $language) {
        if ($language == "AR") {
            $message = "سوف يتم عرض السيارات المناسبة لكم من خلال احد مسئولى خدمة العملاء 🤝" . "\n";
        }else{
            $message = "Our customer service team will show you the most suitable cars for you 🤝" . "\n";
        }

        $this->sendMessage($to, $message);

        if ($language == "AR"){
            $message = "ونود اعلامكم ان 🗒️" . "\n";
            $message .= "* الاوراق المطلوبة للتأجير هي ( جواز سفر ساري – الرخصة الدولية ) " . "\n";
            $message .= "* عدد الكيلو مترات اليومية المجانية هي 120 كم" . "\n";
            $message .= "* سعر الكيلومتر الزيادة هو 5 ج " . "\n";
        }else{
            $message .= "We would like to inform you that 🗒️" . "\n";
            $message .= "* Required documents for rental: (Valid passport – International Driving License) " . "\n";
            $message .= "* Daily free mileage is 120 km" . "\n";
            $message .= "* Additional kilometer charge is 5 EGP" . "\n";
        }

        $this->sendMessage($to, $message);
        $this->sessionManager->setState($to, 'wait_for_support_response');
        return true;
    }

    private function handlePickUpAirport($to, $body, $language){
        if ($language == "AR") {
            $message = "سوف يتم عرض السيارات المناسبة لكم من خلال احد مسئولى خدمة العملاء 🤝" . "\n";

        }else{
            $message = "Our customer service team will show you the most suitable cars for you 🤝" . "\n";
        }
        $this->sendMessage($to, $message);
        if ($language == "AR"){
            $message = "ونود اعلامكم ان 🗒️" . "\n";
            $message .= "* الاوراق المطلوبة للتأجير هي ( جواز سفر ساري – الرخصة الدولية ) " . "\n";
            $message .= "* عدد الكيلو مترات اليومية المجانية هي 20 كم" . "\n";
            $message .= "* سعر الكيلومتر الزيادة هو 5 ج " . "\n";
            $message .= "* رسوم الاستلام من المطار 300 ج " . "\n";
        }
        else{
            $message = "We would like to inform you that 🗒️" . "\n";
            $message .= "* Required documents for rental: (Valid passport – International Driving License) " . "\n";
            $message .= "* Daily free mileage is 120 km" . "\n";
            $message .= "* Additional kilometer charge is 5 EGP" . "\n";
            $message .= "Airport pickup fee 300 EGP" . "\n";
        }
        $this->sendMessage($to, $message);
        $this->sessionManager->setState($to, 'wait_for_support_response');
        return true;
    }

    private function handlePickUpPrivateLocation($to, $body, $language){
        if ($language == "AR") {
            $message = "سوف يتم عرض السيارات المناسبة لكم من خلال احد مسئولى خدمة العملاء 🤝" . "\n";
        }else{
            $message = "Our customer service team will show you the most suitable cars for you 🤝" . "\n";
        }

        $this->sendMessage($to, $message);

        if ($language == "AR"){
            $message = "ونود اعلامكم ان 🗒️" . "\n";
            $message .= "* الاوراق المطلوبة للتأجير هي ( جواز سفر ساري – الرخصة الدولية ) " . "\n";
            $message .= "* عدد الكيلو مترات اليومية المجانية هي 20 كم" . "\n";
            $message .= "* سعر الكيلومتر الزيادة هو 5 ج " . "\n";
            $message .= "* رسوم الاستلام من موقع خاص 300 ج " . "\n";
        }else{
            $message = "We would like to inform you that 🗒️" . "\n";
            $message .= "* Required documents for rental: (Valid passport – International Driving License) " . "\n";
            $message .= "* Daily free mileage is 120 km" . "\n";
            $message .= "* Additional kilometer charge is 5 EGP" . "\n";
            $message .= "Private location pickup fee 300 EGP" . "\n";
        }

        $this->sendMessage($to, $message);
        $this->sessionManager->setState($to, 'wait_for_support_response');
        return true;
    }

    private function handleInvalidOption($to, $language) {
        if ($language == 'AR') {
            $message = "عذراً، الخيار غير صحيح. يرجى اختيار رقم من القائمة.";
        } else {
            $message = "Sorry, invalid option. Please select a number from the menu.";
        }

        $this->whatsAppService->sendMessage($to, $message);
        $this->sendCarRentalMenu($to, $language);
        return true;
    }
}
