<?php
namespace AlGhazal\Handlers;

use AlGhazal\Core\SessionManager;

/**
 * Handler for customer service related flows
 */
class CustomerServiceHandler extends BaseHandler {
    private SessionManager $sessionManager;

    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
        $this->sessionManager = new SessionManager();
    }

    public function handle($to, $body, $language) {
        // Get the current state from the session manager
        $state = $this->sessionManager->getState($to);
        
        // Check if this is a customer service request from the main menu
        if ($body == '0' && $state == 'main_menu') {
            $this->handleCustomerSupport($to, $language);
            return true;
        }
        
        switch ($state) {
            case 'customer_support_message':
                return $this->handleCustomerSupportMessage($to, $body, $language);

            default:
                return false;
        }
    }

    private function handleCustomerSupport($to, $language){
        if ($language == "AR"){
            $message = "نأسف لسماع ان لديكم شكوى او مشكلة 😔 " . "\n";
            $message .= "ولكن نعدكم بان نسعى لحل هذ المشكلة في اقرب وقت ";
            $message .= "برجاء كتابة الشكوى 🙏";
        }else{
            $message = "We're sorry to hear that you have a complaint or problem 😔" . "\n";
            $message .= "But we promise to work on solving this issue as soon as possible. ";
            $message .= "Please write your complaint 🙏";
        }
        $this->sendMessage($to, $message);
        $this->sessionManager->setState($to, 'customer_support_message');
        return true;
    }

    private function handleCustomerSupportMessage($to, $body, $language){
        $this->sessionManager->setState($to, 'wait_for_support_response');
        return true;
    }
}
