<?php
namespace AlGhazal\Handlers;

use AlGhazal\Core\SessionManager;
use AlGhazal\Utils\MessageFormatter;

/**
 * Handler for car rental related flows
 */
class LimoHandler extends BaseHandler {
    private SessionManager $sessionManager;

    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
        $this->sessionManager = new SessionManager();
    }

    public function handle($to, $body, $language) {
        $state = $this->sessionManager->getState($to);
        if ($body == '2' && $state == 'main_menu') {
            $this->sendLimoMenu($to, $language);
            $this->sessionManager->setState($to, 'wait_for_support_response');
            return true;
        }
        return false;
    }

    private function sendLimoMenu($to, $language){
        if ($language == "AR"){
            $message =  "تشرفنا بسيادتكم ونسعى دائما لتقديم افضل السيارات مع امهر السائقين 👮🏽‍♂️🚗". "\n";
            $message .= "وسوف يتم عرض السيارات المناسبة لكم من خلال احد مسئولى خدمة العملاء 🤝" . "\n";

        }else{
            $message = "We are honored by your presence and we always strive to provide the best cars with the most skilled drivers 👮🏽‍♂️🚗" . "\n";
            $message .= "Our customer service team will show you the most suitable cars for you 🤝" . "\n";
        }

        $this->sendMessage($to, $message);

        if ($language == "AR"){
            $message = 'ونود اعلامكم ان 🗒' . '\n';
            $message .= '* مواعيد السيارة 12 ساعة مع السائق شامل اجرة السائق ' . '\n';
            $message .= '* الاوراق المطلوبة ( جواز سفر ساري ) ' . '\n';
            $message .= '* عدد الكيلو مترات اليومية المجانية هي 120 كم' . '\n';
            $message .= '* سعر الكيلومتر الزيادة هو 5 ج ' . '\n';
        }
        else{
            $message = 'We would like to inform you that 🗒' . '\n';
            $message .= '* Car availability: 12 hours with driver (driver fee included)' . '\n';
            $message .= '* Required documents: (Valid passport)' . '\n';
            $message .= '* Daily free mileage is 120 km' . '\n';
            $message .= '* Additional kilometer charge is 5 EGP' . '\n';
        }

        $this->sendMessage($to, $message);
        return true;
    }
}
