<?php
namespace AlGhazal\Handlers;

use AlGhazal\Core\SessionManager;

/**
 * Handler for customer service related flows
 */
class LocationHandler extends BaseHandler {
    private SessionManager $sessionManager;

    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
        $this->sessionManager = new SessionManager();
    }

    public function handle($to, $body, $language) {
        // Get the current state from the session manager
        $state = $this->sessionManager->getState($to);

        // Check if this is a customer service request from the main menu
        if ($body == '4' && $state == 'main_menu') {
            $this->handleLocation($to, $language);
            return true;
        }
    }

    private function handleLocation($to, $language){
        if ($language == "AR"){
            $message = "نتشرف بزيارتك في العنوان : ٢ ش سليمان اباظه اعلى مطعم بيت ورد- جامعة الدول العربية - الجيزة";
            $this->sendMessage($to, $message);
            $message = "https://maps.app.goo.gl/FSYd2NjBWRRNJsAB8";
            $this->sendMessage($to, $message);
            $message = "في انتظارك من الساعة العاشرة صباحا حتى الساعة العاشرة مساءا 🤝";
            $this->sendMessage($to, $message);
        }else{
            $message = "We are honored by your visit at: 2 Suleiman Abaza Street, above Beit Ward Restaurant - Arab League - Giza";
            $this->sendMessage($to, $message);
            $message = "https://maps.app.goo.gl/FSYd2NjBWRRNJsAB8";
            $this->sendMessage($to, $message);
            $message = "Waiting for you from 10:00 AM until 10:00 PM 🤝";
            $this->sendMessage($to, $message);
        }
        $this->sessionManager->setState($to, 'welcome');
        return true;
    }
}
