<?php

namespace AlGhazal\Handlers;

use AlGhazal\Core\SessionManager;

/**
 * Handler for service rating related flows
 */
class SessionHandler extends BaseHandler
{
    private SessionManager $sessionManager;

    /**
     * Constructor
     */
    public function __construct()
    {
        parent::__construct();
        $this->sessionManager = new SessionManager();
    }

    /**
     * Handle the message based on the conversation flow
     *
     * @param string $to Recipient phone number (used as chat ID)
     * @param string $body Message body
     * @param string $language Language (AR or EN)
     * @return bool Whether the message was handled
     */
    public function handle($to, $body, $language)
    {
        if ($body == "session")
            return $this->handleSession($to, $body, $language);
        return false;
    }

    private function handleSession($to, $body, $language){
        if($language == "AR"){
            $message = "لم يصلنا اي رد منك منذ فترة";
            $this->whatsAppService->sendMessage($to, $message);
            $message = "تشرفنا بخدمتكم .. ونسعي لتقديم افضل مستوي من الخدمة 🤝";
            $message .= "\n"."شكرآ لاختيارك شركة الغزال";
        }
        else{
            $message = "We haven't received any response from you for a while";
            $this->whatsAppService->sendMessage($to, $message);
            $message = "We are honored to serve you...and we strive to provide the best level of service 🤝";
            $message .= "\n"."Thank you for choosing Al Ghazal Company";
        }

        $this->whatsAppService->sendMessage($to, $message);
        $this->sessionManager->setState($to, 'welcome');
        return true;
    }
}
