<?php
namespace AlGhazal\Handlers;

use AlGhazal\Core\SessionManager;

/**
 * Handler for welcome messages and language selection
 */
class WelcomeHandler extends BaseHandler {
    private $sessionManager;
    
    /**
     * Constructor
     */
    public function __construct() {
        parent::__construct();
        $this->sessionManager = new SessionManager();
    }
    
    /**
     * Handle the message based on the conversation flow
     * 
     * @param string $to Recipient phone number (used as chat ID)
     * @param string $body Message body
     * @param string $language Language (AR or EN)
     * @return bool Whether the message was handled
     */
    public function handle($to, $body, $language) {
        $state = $this->sessionManager->getState($to);

        if ($state !== 'welcome') {
            return false;
        }

        if (!$this->sessionManager->getData($to, 'language_selector')){
            $this->sendWelcomeMessage($to);
            $this->sessionManager->setData($to, 'language_selector', true);
            return true;
        }

        $language = $body == '1' ? 'AR' : 'EN';
        $this->sessionManager->setLanguage($to, $language);
        $this->sendMainMenu($to, $language);
        $this->sessionManager->setState($to, 'main_menu');
        $this->sessionManager->setData($to, 'language_selector', false);
        return true;
    }
    
    /**
     * Send welcome message
     * 
     * @param string $to Recipient phone number (used as chat ID)
     * @return void
     */
    private function sendWelcomeMessage($to) {
        $message = "مرحبا بك بشركة المقام لتأجير السيارات 🤝";
        $this->sendMessage($to, $message);


        if (isset($sessionData['offer']) && $sessionData['offer']) {
            $image = $sessionData['image'];
            $caption = $sessionData['arabic_title'];
            $caption = $caption."\n\n"."http://admin.alghazal.sa/od/".$sessionData['offer_id'];
            $this->whatsAppService->sendImage($to, $image, $caption);
        }

        // Language selection message - exactly as in original Webhook.php
        $message = "1.اللغة العربية";
        $message .= "\n"."2.For English";
        $this->sendMessage($to, $message);
    }
}
