<?php
namespace AlGhazal\Utils;

/**
 * Helper utility functions
 */
class Helpers {
    /**
     * Convert Arabic numerals to English numerals
     * 
     * @param string $string Input string
     * @return string Converted string
     */
    public static function englishConverter($string) {
        $arabic = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];
        $english = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        
        return str_replace($arabic, $english, $string);
    }
}
