<?php
namespace AlGhazal\Utils;

use AlGhazal\Services\WhatsAppService;

/**
 * Helper class for menu-related functionality
 */
class MenuHelper {
    /**
     * Get the main menu message
     * 
     * @param string $language Language code (AR or EN)
     * @return string The formatted menu message
     */
    public static function getMainMenuMessage($language) {
        if ($language == 'AR') {
            $message = "يسعدنا خدمتك 😊";
            $message .= " برجاء اختيار رقم الخدمة المطلوبة 🙏:" . "\n";
            $message .= "1- ايجار سيارة 🚗" . "\n";
            $message .= "2- ايجار سيارة بسائق 👮🏽‍♂️" . "\n";
            $message .= "3- تسليم السيارة المؤجرة 🚘" . "\n";
            $message .= "4- العنوان ومواعيد العمل 🕦" . "\n";
            $message .= "‐--------------------------------" . "\n";
            $message .= "0- للشكاوي والدعم الفنى 💬" . "\n";
        } else {
            $message = "We're happy to serve you 😊";
            $message .= "Please choose the service number you need 🙏:" . "\n";
            $message .= "1- Rent a car 🚗" . "\n";
            $message .= "2- Rent a car with a driver 👮🏽‍♂️" . "\n";
            $message .= "3- Return the rented car 🚘" . "\n";
            $message .= "4- Address and Working Hours 🕦" . "\n";
            $message .= "‐--------------------------------" . "\n";
            $message .= "0- For complaints and technical support 💬" . "\n";
        }
        return $message;
    }
}
