<?php
namespace AlGhazal\Utils;

/**
 * Utility class for formatting messages to be displayed to users
 */
class MessageFormatter {
    /**
     * Format brands list for display
     * 
     * @param array $brands Brands data from API
     * @param string $language Language (AR or EN)
     * @return string Formatted brands list
     */
    public static function formatBrands($brands, $language) {
        $counter = 1;
        $brandList = "";
        
        foreach ($brands as $brand) {
            if ($language == "AR") {
                $brandList = $brandList."\n *".$counter.".* ".$brand['arabic_name'];
            } else {
                $brandList = $brandList."\n *".$counter.".* ".$brand['name'];
            }
            $counter++;
        }
        
        return $brandList;
    }
    
    /**
     * Format sub-brands list for display
     * 
     * @param array $subBrands Sub-brands data from API
     * @param string $language Language (AR or EN)
     * @return string Formatted sub-brands list
     */
    public static function formatSubBrands($subBrands, $language) {
        $counter = 1;
        $subBrandList = "";
        
        foreach ($subBrands as $subBrand) {
            if ($language == "AR") {
                $subBrandList = $subBrandList."\n *".$counter.".* ".$subBrand['arabic_name'];
            } else {
                $subBrandList = $subBrandList."\n *".$counter.".* ".$subBrand['name'];
            }
            $counter++;
        }
        
        return $subBrandList;
    }
    
    /**
     * Format cars list for display
     * 
     * @param array $cars Cars data from API
     * @param string $language Language (AR or EN)
     * @return string Formatted cars list
     */
    public static function formatCars($cars, $language) {
        $counter = 1;
        $carsList = "";
        
        foreach ($cars as $car) {
            if ($language == "AR") {
                $carsList = $carsList."\n *".$counter.".* ".$car['arabic_name'];
            } else {
                $carsList = $carsList."\n *".$counter.".* ".$car['name'];
            }
            $counter++;
        }
        
        return $carsList;
    }
    
    /**
     * Format contracts list for display
     * 
     * @param array $contracts Contracts data from API
     * @return string Formatted contracts list
     */
    public static function formatContracts($contracts) {
        if (!count($contracts)) {
            return null;
        }
        
        $counter = 1;
        $contractList = "";
        
        foreach ($contracts as $contract) {
            $contractList = $contractList."\n *".$counter.".* ".$contract['name'];
            $counter++;
        }
        
        return $contractList;
    }
    
    /**
     * Format branches list for display
     * 
     * @param array $branches Branches data from API
     * @param string $language Language (AR or EN)
     * @return string Formatted branches list
     */
    public static function formatBranches($branches, $language) {
        $counter = 1;
        $branchesList = "";
        
        foreach ($branches as $branch) {
            if ($language == "AR") {
                $branchesList = $branchesList."\n *".$counter.".* ".$branch['arabic_name'];
            } else {
                $branchesList = $branchesList."\n *".$counter.".* ".$branch['name'];
            }
            $counter++;
        }
        
        return $branchesList;
    }
    
    /**
     * Format offers list for display
     * 
     * @param array $offers Offers data from API
     * @param string $language Language (AR or EN)
     * @return string Formatted offers list
     */
    public static function formatOffers($offers, $language) {
        $counter = 1;
        $offersList = "";
        
        foreach ($offers as $offer) {
            if ($language == "AR") {
                $offersList = $offersList."\n *".$counter.".* ".$offer['arabic_title'];
                $offersList = $offersList."\n".$offer['arabic_description']."\n";
            } else {
                $offersList = $offersList."\n *".$counter.".* ".$offer['title'];
                $offersList = $offersList."\n".$offer['description']."\n";
            }
            $counter++;
        }
        
        return $offersList;
    }
}
